import requests
import json
import mysql.connector

# تحديد المعلومات اللازمة
email = "mtc9afd-01@makamat.com"  # يمكنك تغييرها بالبريد الإلكتروني الخاص بك
password = "mtc9afd-2023"  # يمكنك تغييرها بكلمة مرورك

# بناء البيانات المرسلة كنص مشفر
post_data = {
    'email': email,
    'password': password
}

# إرسال طلب POST للحصول على رمز التميز
response = requests.post(
    'https://mtc9afd-01.azurewebsites.net/api/Auth/login',
    headers={
        'Content-Type': 'application/json',
        'cache-control': 'no-cache'
    },
    json=post_data,
    verify=False  # تعطيل التحقق من الشهادة
)

# التحقق من وجود أخطاء في الطلب
if response.status_code != 200:
    print(f"خطأ في الاتصال بالخادم: {response.text}")
else:
    # تحويل الرد إلى مصفوفة جسون
    response_array = response.json()

    if 'token' in response_array:
        # استخراج الرمز المميز من الرد
        token = response_array['token']

        # عرض الرمز المميز
        print(f"token : {token}")

        # بناء الطلب الجديد للحصول على بيانات RFID
        response = requests.get(
            'https://mtc9afd-01.azurewebsites.net/api/AssetInformation',
            headers={
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json',
                'cache-control': 'no-cache'
            },
            verify=False  # تعطيل التحقق من الشهادة
        )

        # التحقق من وجود أخطاء في الطلب
        if response.status_code != 200:
            print(f"خطأ في الاتصال بالخادم: {response.text}")
        else:
            # تحويل الرد إلى مصفوفة جسون
            data = response.json()

            # الاتصال بقاعدة البيانات MySQL
            # الاتصال بقاعدة البيانات MySQL
            try:
                db_connection = mysql.connector.connect(
                    host="vsrv681.armadaservers.com",
                    user="mint303_change_stock",
                    password="Plmokn123@",
                    database="mint303_change_stock"
                )
                db_cursor = db_connection.cursor()

                # استعداد البيانات للإدراج
                insert_data = []

                # البحث عن القيم الموجودة في جدول آخر
                for row in data:
                    assetInformationId = row['assetInformationId']

                    # إضافة القيم إلى قائمة الإدراج
                    insert_data.append((
                        assetInformationId,
                        row['epc'],
                        row['tagNumber'],
                        row['assetBarcode'],
                        row['manufacturer'],
                        row['model'],
                        row['serialNumber'],
                        row['poNumber'],
                        row['sapNumber'],
                        row['assetCode'],
                        row['assetType'],
                        row['assetImage1'],
                        row['assetImage2'],
                        row['assetImage3'],
                        row['userNumber'],
                        row['currentConditionId'],
                        row['assetImage4'],
                        row['motorLicensePlate'],
                        row['motorVinNumber'],
                        row['assetImage5'],
                        row['assetImage6'],
                        row['assetImage7'],
                        row['timestamp']
                    ))

                # الاستعلام عن القيم الموجودة بشكل دفعي
                sql_query = "SELECT assetInformationId FROM AssetInformation WHERE assetInformationId IN (%s)" % ','.join(['%s'] * len(insert_data))
                db_cursor.execute(sql_query, [i[0] for i in insert_data])
                existing_rows = db_cursor.fetchall()

                existing_ids = set(row[0] for row in existing_rows)

                # تحديث القيمة في جدول البيانات أو إدراج القيم الجديدة
                for item in insert_data:
                    if item[0] in existing_ids:
                        print(f"Existing: {item[0]}")
                    else:
                        # استعلام الإدراج
                        insert_query = "INSERT INTO AssetInformation (assetInformationId , epc , tagNumber , assetBarcode , manufacturer , model , serialNumber , poNumber , sapNumber , assetCode , assetType , assetImage1 , assetImage2 , assetImage3 , userNumber , currentConditionId , assetImage4 , motorLicensePlate , motorVinNumber , assetImage5 , assetImage6 , assetImage7 , timestamp ) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)"
                        db_cursor.execute(insert_query, item)
                        print(f"Does not exist: {item[0]}")

                # تأكيد التغييرات
                db_connection.commit()
                print("The data has been updated successfully")

            except mysql.connector.Error as error:
                print(f"An error occurred while connecting to the database: {error}")

            finally:
                # إغلاق الاتصال بقاعدة البيانات
                if db_connection.is_connected():
                    db_cursor.close()
                    db_connection.close()
                    print("The connection to the database has been closed")


    else:
        print(f"An error occurred in obtaining the token: {response.text}")
